/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.*;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;

public class Tracker extends Widget {
	Control parent;
	
public Tracker (Composite parent, int style) {
	super (parent, checkStyle(style));
	this.parent = parent;
}

public Tracker (Display display, int style) {
	if (display == null) display = Display.getCurrent ();
	if (display == null) display = Display.getDefault ();
	if (!display.isValidThread ()) {
		error (SWT.ERROR_THREAD_INVALID_ACCESS);
	}
	this.display = display;
	this.style = style;
}

public void addControlListener (ControlListener listener) {
}

public void addKeyListener (KeyListener listener) {
}

static int checkStyle (int style) {
	if ((style & (SWT.LEFT | SWT.RIGHT | SWT.UP | SWT.DOWN)) == 0) {
		style |= SWT.LEFT | SWT.RIGHT | SWT.UP | SWT.DOWN;
	}
	return style;
}

public void close () {
}

public Rectangle[] getRectangles () {
	return null;
}

public boolean getStippled () {
	return false;
}

public boolean open () {
	return false;
}

public void removeControlListener (ControlListener listener) {
}

public void removeKeyListener (KeyListener listener) {
}

public void setCursor (Cursor newCursor) {
}

public void setRectangles (Rectangle[] rectangles) {
}

public void setStippled (boolean stippled) {
}

}
